void Main()
{
  AddFilesToFolder();

  var tarPath = Path.Combine (DirectoryToTarball, "..", "archive.tar");
  TarFile.CreateFromDirectory (DirectoryToTarball, tarPath, false);

  Directory.CreateDirectory (DirectoryToExtractTo);
  TarFile.ExtractToDirectory (tarPath, DirectoryToExtractTo, true);

  Directory.EnumerateFiles (DirectoryToExtractTo).Dump ("Extracted files");
}

string DirectoryToTarball =>
  RuntimeInformation.IsOSPlatform (OSPlatform.Windows)
    ? @".\MyFolder"
    : "./MyFolder";

string DirectoryToExtractTo =>
  RuntimeInformation.IsOSPlatform (OSPlatform.Windows)
    ? @".\Extracted"
    : "./Extracted";

void AddFilesToFolder()
{
  Directory.CreateDirectory (DirectoryToTarball);
  foreach (var c in new char[] { 'A', 'B', 'C' })
    File.WriteAllText (Path.Combine (DirectoryToTarball, $"{c}.txt"), $"This is {c}");
}